#include <stdio.h>
#include <string.h>

typedef struct
{
	char ime[20];
	int redniBroj;
	int broj;
}Dete;

int unosDeteta(char nazivFajla[], Dete deca[])
{
	int i = 0;
	
	FILE * fajl = fopen(nazivFajla, "r");
	
	while(!feof(fajl))
	{
		fscanf(fajl, "%s", deca[i].ime);
		fscanf(fajl, "%d", &deca[i].broj);
		
		deca[i].redniBroj = i++;
	}
	
	fclose(fajl);
	
	return i;
}

void ispisDece(Dete deca[], int n, FILE * fajl)
{
	int i = 0;
	
	for( i = 0; i < n; i++)
	{
		fprintf(fajl, "\nrbr = %d, Ime = %s, broj = %d \n", deca[i].redniBroj, deca[i].ime, deca[i].broj);		
	}
}

int formIgru(Dete deca[], int n, Dete decaKojaSeIgraju[])
{
	int m = 0;
	int i, j;
	int daLiJeJedinstven;
	
	for( i = 0; i < n; i++)
	{
		daLiJeJedinstven = 0;
		
		for(j = 0; j < n; j++)
		{
			if(i != j && deca[i].broj == deca[j].broj)
			{
				daLiJeJedinstven = 1;
				break;		
			}
		}
		
		if(daLiJeJedinstven)
		{
			decaKojaSeIgraju[m] = deca[i];
			m++;
		}
	}
	
	return m;
}

int formSpisak(Dete deca[], int n, int brojevi[], int ponavljanja[])
{
	int i, j;
	int m = 0;
	
	for( i = 0; i < n; i++)
	{
		for( j = 0; j < m; j++)
		{
			if(brojevi[j] == deca[i].broj)
			{
				ponavljanja[j]++;
				break;
			}
		}
		
		if(j == m)
		{
			brojevi[j] = deca[i].broj;
			ponavljanja[j] = 1;
			m++;
		}
	}
	
	return m;
}

int najkraceIme(Dete deca[], int n)
{
	int rbr;
	int minimalnaDuzina;
	int i;
	
	rbr = deca[0].redniBroj;
	minimalnaDuzina = strlen(deca[0].ime);
	
	int duzina;
	for(i = 1; i < n; i++)
	{
		duzina = strlen(deca[i].ime);
		if(duzina < minimalnaDuzina)
		{
			minimalnaDuzina = duzina;
			rbr = deca[i].redniBroj;
		}	
	}
	
	return rbr;	
}

main()
{
	char nazivUlaznogFajlaSaDecom[20];
	char nazivIzlaznogFajlaSaDecom[20];
	Dete deca[50], decaKojaSeIgraju[50];
	int a[50], b[50];
	int brojDece, brojDeceKojaSeIgraju, nBrojeva, i;
	
	printf("Unesite naziv ulaznog fajla:\n");
	scanf("%s", nazivUlaznogFajlaSaDecom);
	
	printf("Unesite naziv izlaznog fajla:\n");
	scanf("%s", nazivIzlaznogFajlaSaDecom);
	
	FILE *f = fopen(nazivIzlaznogFajlaSaDecom, "w");
	
	brojDece = unosDeteta(nazivUlaznogFajlaSaDecom, deca);
	
	ispisDece(deca, brojDece, f);

	int id = najkraceIme(deca, brojDece);
	
	printf("Rbr = %d, Ime = %s, broj = %d \n\n", deca[id].redniBroj, deca[id].ime, deca[id].broj);		

	brojDeceKojaSeIgraju = formIgru(deca, brojDece, decaKojaSeIgraju);
	
	fprintf(f, "\n----------------------------------\n");
	
	ispisDece(decaKojaSeIgraju, brojDeceKojaSeIgraju, f);
	
	fclose(f);
	
	nBrojeva = formSpisak(deca, brojDece, a, b);
	
	for(i = 0; i < nBrojeva; i++)
		printf("%d %d\n", a[i], b[i]);
}
